<?php
/**
 * This file contains the class for rendering the feeds page.
 *
 * @package    Nelio_Content
 * @subpackage Nelio_Content/admin/pages
 * @author     David Aguilera <david.aguilera@neliosoftware.com>
 * @since      2.0.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * Class that renders the feeds page.
 */
class Nelio_Content_Feeds_Page extends Nelio_Content_Abstract_Page {

	public function __construct() {

		parent::__construct(
			'nelio-content',
			'nelio-content-feeds',
			_x( 'Feeds', 'text', 'nelio-content' ),
			nelio_content_can_current_user_use_plugin()
		);
	}

	// @Overrides
	protected function add_page_specific_hooks() {
		remove_all_filters( 'admin_notices' );
	}

	// @Overrides
	public function init() {

		$settings = Nelio_Content_Settings::instance();
		if ( empty( $settings->get( 'use_feeds' ) ) ) {
			return;
		}

		parent::init();
	}

	// @Implements
	public function enqueue_assets() {

		wp_enqueue_style(
			'nelio-content-feeds-page',
			nelio_content()->plugin_url . '/assets/dist/css/feeds-page.css',
			array( 'nelio-content-components' ),
			nelio_content_get_script_version( 'feeds-page' )
		);
		nelio_content_enqueue_script_with_auto_deps( 'nelio-content-feeds-page', 'feeds-page', true );

		wp_add_inline_script(
			'nelio-content-feeds-page',
			'NelioContent.initPage( "nelio-content-feeds-page" );'
		);
	}
}
